<?php

namespace Ignite\Core\Entities;

use Illuminate\Database\Eloquent\Model;

class Note extends Model
{
    /**
     * The custom table name.
     * @var string
     */
    protected $table = 'core_note';

    /**
     * The custom primary key.
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * The attributes to be guarded from mass assignment.
     * @var array
     */
    protected $guarded = [];

    /**
     * The relationship to the User.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * The relationship to the user that added the note.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function addedBy()
    {
        return $this->hasOne(User::class, 'user_id', 'by_user_id');
    }
}
