<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCoreParticipantTable extends Migration
{
    protected $tableName = 'core_participant';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('user_id');
            $table->string('title')->nullable()->default(null);
            $table->string('email');
            $table->string('first')->default(null);
            $table->string('last')->default(null);
            $table->string('type')->nullable()->default(null);
            //$table->unsignedInteger('partner_id')->nullable()->default(null);
            $table->string('employee_id')->nullable()->default(null);
            $table->string('phone1')->nullable()->default(null);
            $table->string('phone2')->nullable()->default(null);
            $table->string('phone3')->nullable()->default(null);
            $table->string('company')->nullable()->default(null);
            $table->string('department_1')->nullable()->default(null);
            $table->string('department_2')->nullable()->default(null);
            $table->string('address_1')->nullable()->default(null);
            $table->string('address_2')->nullable()->default(null);
            $table->string('city')->nullable()->default(null);
            $table->string('state')->nullable()->default(null);
            $table->string('postal')->nullable()->default(null);
            $table->string('country')->nullable()->default(null);
            $table->string('work_address_1')->nullable()->default(null);
            $table->string('work_address_2')->nullable()->default(null);
            $table->string('work_city')->nullable()->default(null);
            $table->string('work_state')->nullable()->default(null);
            $table->string('work_postal')->nullable()->default(null);
            $table->string('work_country')->nullable()->default(null);
            $table->string('alternate_email')->nullable()->default(null);
            $table->string('region')->nullable()->default(null);
            $table->date('dob')->nullable()->default(null);
            $table->string('ssn')->nullable()->default(null);
            $table->string('agree_confirm_1')->nullable()->default(0);
            $table->string('agree_confirm_2')->nullable()->default(0);
            $table->unsignedTinyInteger('status')->default(1);
            $table->unsignedTinyInteger('archived')->default(0);
            $table->binary('idc')->nullable();
            $table->boolean('internal')->default(0);
            $table->text('internal_notes')->nullable()->default(null);
            $table->timestamp('approved_at')->nullable()->default(null);
            $table->softDeletes('deleted_at');
            $table->timestamps();
            $table->index('country');
            //$table->index('partner_id');
            $table->foreign('user_id')->references('user_id')->on('core_user')->onUpdate('cascade');
            //$table->foreign('partner_id')->references('partner_id')->on('partner')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
