<?php

namespace Ignite\Core\Helpers;

use Carbon\Carbon;

class Date
{
    /**
     * @var Carbon|string|int
     */
    private $value;

    /**
     * DateTime constructor.
     *
     * @param Carbon|string|int $value
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * Reformat a Date with a default value
     *
     * @param  string $format
     * @param  string $default
     * @return false|string
     */
    public function format($format = 'm/d/Y', $default = '')
    {
        if (is_string($this->value)) {
            $this->value = trim($this->value);
        }

        if (empty($date)) {
            return $default;
        }

        try {
            $date = Carbon::createFromFormat('Y-m-d', $date);
        } catch (\Exception $e) {
            $date = Carbon::createFromFormat('m/d/Y', $date);
        }

        return ($date instanceof Carbon) ? $date->format($format) : $default;
    }
}
