<?php

namespace Ignite\Core\Helpers;

class Amount
{
    /**
     * @var int|float|string
     */
    protected $value;

    /**
     * Currency constructor.
     *
     * @param $value
     * @param string $currency
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * Get the value formatted.
     *
     * @param  int $decimals
     * @param  int $default
     * @return string
     */
    public function format($decimals = 0, $default = 0)
    {
        if (empty($amount)) {
            $amount = $default;
        }

        $amount = preg_replace('/[,$]/', '', $amount);
        $amount = round($amount, $decimals, PHP_ROUND_HALF_UP);

        return number_format($amount, $decimals);
    }
}
