<?php

namespace Ignite\Core\Tests\Unit\Models\Menu;

use Ignite\Core\Models\Menu\Item;
use Ignite\Core\Tests\TestCase;

class ItemTest extends TestCase
{
    /**
     * @test
     * @group Cms
     */
    public function it_can_get_the_item_url()
    {
        $item = new Item('test', 'Test', 100, true);
        $this->assertEquals('/test', $item->getUrl());
    }

    /**
     * @test
     * @group Cms
     */
    public function it_can_get_the_item_label()
    {
        $item = new Item('test', 'Test', 100, true);
        $this->assertEquals('Test', $item->getLabel());
    }

    /**
     * @test
     * @group Cms
     */
    public function it_can_get_the_item_position()
    {
        $item = new Item('test', 'Test', 100, true);
        $this->assertEquals(100, $item->getPosition());
    }

    /**
     * @test
     * @group Cms
     */
    public function it_can_be_viewed_by_default()
    {
        $item = new Item('test', 'Test', 100);
        $this->assertTrue($item->canBeViewed());
    }

    /**
     * @test
     * @group Cms
     */
    public function it_set_can_be_viewed_to_false_via_the_constructor()
    {
        $item = new Item('test', 'Test', 100, false);
        $this->assertFalse($item->canBeViewed());
    }


    /**
     * @test
     * @group Cms
     */
    public function it_allows_an_item_to_have_a_child_collection()
    {
        $item = new Item('/test', 'Parent', 10, true);

        $this->assertInstanceOf(\Illuminate\Support\Collection::class, $item->getChildren());
    }

    /**
     * @test
     * @group Cms
     */
    public function it_can_add_a_child_item()
    {
        $item = new Item('/test', 'Parent', 10, true);

        $item->addChild(
            new Item('/test/child', 'Child', 1, true)
        );

        $this->assertTrue($item->hasChildren());
        $this->assertTrue($item->hasChild('/test/child'));
    }


    /**
     * @test
     * @group Cms
     */
    public function it_can_remove_a_child_item()
    {
        $item = new Item('/test', 'Parent', 10, true);

        $item->addChild(
            new Item('/test/child', 'Child', 10, true)
        );

        $this->assertTrue($item->hasChild('/test/child'));
        $item->removeChild('/test/child');
        $this->assertFalse($item->hasChild('/test/child'));
    }

    /**
     * @test
     * @group Cms
     */
    public function it_can_key_child_items_by_url()
    {
        $item = new Item('/test', 'Parent', 10, true);

        $item->addChild(
            new Item('/test/child', 'Child', 10, true)
        );

        $this->assertTrue(
            in_array('/test/child', $item->getChildren()->keys()->toArray())
        );
    }

    /**
     * @test
     * @group Cms
     */
    public function it_can_order_child_items_by_position()
    {
        $item = new Item('/test', 'Parent', 10, true);

        $item->addChild(
            new Item('/test/child', 'Child', 10, true)
        );

        $item->addChild(
            new Item('/test/child2', 'Favourite Child', 5, true)
        );

        $this->assertEquals(5, $item->getChildren()->first()->position);
    }
}
