@extends('Core::layouts.import')

@section('page_heading', 'Import')
@section('page_breadcrumb', 'Import')

@section('page_content')
    <div class="row">
        <div class="col-md-4">
            <form id="import-form" action="{{ route('admin.import.run', $import) }}" method="post">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            Importing {{ str_plural($import->getTypeLabel()) }}
                        </h3>
                        <div class="badge pull-right">{{ $import->records }} records</div>
                    </div>
                    <div class="box-body">
                        @foreach ($import->toPresentableArray() as $key => $value)
                        <dl class="dl-horizontal ig-list-horizontal">
                            <dt class="ig-list-horizontal-label" style="text-align: left; width: 85px;">{{ str_replace('_', ' ', title_case($key)) }}</dt>
                            <dd style="margin-left: 85px;">{{ $value }}</dd>
                        </dl>
                        @endforeach
                    </div>
                    <div class="box-footer">
                        {{ csrf_field() }}
                        <a href="{{ route('admin.import.index') }}" class="btn btn-default pull-left">
                            <span class="fa fa-chevron-left"></span>
                            <span>Back</span>
                        </a>
                        @if ($import->isPending())
                            @can('core.import.run')
                            <button id="start-import" class="btn btn-primary pull-right" type="submit">
                                <strong>Import</strong>
                                <span class="fa fa-cloud-upload"></span>
                            </button>
                            @endcan
                            @can('core.import.preview')
                            <button id="start-dry-run" class="btn btn-default pull-right" name="dry_run" value="1" type="submit" style="margin-right: 10px;">
                                <strong>Dry Run</strong>
                            </button>
                            @endcan
                        @endif
                    </div>
                </div>
            </form>
            <div class="box box-solid">
                <div class="box-body no-padding">
                    <ul class="nav nav-pills nav-stacked">
                        <li>
                            @can('core.import.download')
                            @if ($import->file)
                                <a href="{{ route('admin.import.download', $import) }}">
                                    <span class="fa fa-cloud-download"></span>
                                    <span>Download the data file</span>
                                </a>
                            @endif
                            @endcan
                            @can('core.import.delete')
                                <a href="{{ route('admin.import.destroy', $import) }}" class="delete-entry">
                                    <span class="fa fa-trash text-danger"></span>
                                    <span class="text-danger">Delete</span>
                                </a>
                            @endcan
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        @can('core.import.preview')
        <div class="col-md-8">
            {!! $import->resolveType()->html() !!}

            <div class="box box-primary" id="import-preview">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        @if ($import->isComplete() || $dryRun)
                            @if ($dryRun)
                                <a href="{{ route('admin.import.show', $import) }}" class="btn btn-default btn-sm pull-left">
                                    <span class="fa fa-chevron-left"></span> Preview
                                </a>
                            @endif
                            <span class="pull-left preview-button-spacing">Results</span>
                        @else
                            Preview
                        @endif
                    </h3>
                    @if ($import->isComplete() || $dryRun)
                    <div class="btn-group pull-right">
                        <a href="{{ route('admin.import.show', ['id' => $import, 'dryRun' => $dryRun]) }}" class="btn btn-sm btn-default {{ request()->has('onlyErrors') ? '' : 'active' }}">Show all</a>
                        <a href="{{ route('admin.import.show', ['id' => $import, 'dryRun' => $dryRun, 'onlyErrors' => true]) }}" class="btn btn-sm btn-default {{ request()->has('onlyErrors') ? 'active' : '' }}">Show errors</a>
                    </div>
                    @endif
                </div>
                @if ($import->isComplete() || $import->isProcessing() || $dryRun)
                    <div class="box-body">
                        @include('Core::admin.import.partials.logs', ['lines' => $import->getFormattedLog()])
                    </div>
                @else
                    @if ($import->isPending())
                    <div class="box-body no-margin no-padding">
                        <ignite-import-preview :id="{{ $import->getKey() }}" :total="{{ (int) $import->records }}"></ignite-import-preview>
                    </div>
                    @else
                    <div class="box-body">
                        <div class="centered text-center">
                            <span class="fa fa-cloud-upload fa-5x text-danger m-5"></span>
                            <p class="no_margin text-danger">No records could be found in the provided import file.</p>
                        </div>
                    </div>
                    @endif
                @endif
            </div>
        </div>
        @endcan
    </div>
    <div id="import-processing" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body no-padding">
                    <div class="alert alert-success text-center no-margin no-radius">
                        <span class="fa fa-5x fa-refresh fa-spin text-white"></span>
                        <h3>Importing...</h3>
                        <p>Your file is being imported, please allow up to 2 minutes for large files.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="import-dry-run" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body no-padding">
                    <div class="alert alert-success text-center no-margin no-radius">
                        <span class="fa fa-5x fa-refresh fa-spin text-white"></span>
                        <h3>Dry Run...</h3>
                        <p>Your file is being imported in "dry run" mode, please allow up to 2 minutes for large files. Nothing will be saved in "dry run" mode. This is just a test.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    @if ($import->isPending() && ! $dryRun)
    <script type="text/javascript" src="{{ asset('vendor/ignite/js/import/import.js') }}"></script>
    @endif
    <script type="text/javascript">
        $(document).ready(function() {
            $('#start-import').on('click', function (evt) {
                if (confirm('Are you sure you want to import?')) {
                    $('#import-processing').modal('show');
                    this.disable();
                    return true;
                }
                return false;
            });

            $('#start-dry-run').on('click', function (evt) {
                var $this = $(this);
                var clickInitial = parseInt($this.data('clicked'), 10) || 0;

                $this.data('clicked', clickInitial + 1);

                if ($this.data('clicked') === 1) {
                    evt.preventDefault();
                    $('#import-dry-run').modal('show');
                    setTimeout(function() {
                        $('#start-dry-run').trigger('click');
                    }, 1000);
                }
            });

            $.deleteEntry({
                confirmation: 'Are you sure you want to delete this import',
                request: { method: 'DELETE', type: 'json' },
                data: {
                    _token: "{{ csrf_token() }}"
                },
                onSuccess: function (button) {
                    window.location.href = "{{ route('admin.import.index') }}";
                }
            });
        });
    </script>
@endsection