<?php

namespace Ignite\Core\Models\Form\Field;

use Kris\LaravelFormBuilder\Fields\FormField;

class Toggle extends FormField
{
    /**
     * @inheritdoc
     */
    protected $valueProperty = 'checked';

    /**
     * @return string
     */
    protected function getTemplate()
    {
        return 'Core::form.field.toggle';
    }

    /**
     * @inheritdoc
     */
    public function getDefaults()
    {
        return [
            'attr' => ['class' => null, 'id' => $this->getName()],
            'value' => 1,
            'checked' => null,
            'show_changed_default' => false,
        ];
    }

    /**
     * Get value property.
     *
     * @param mixed|null $default
     * @return mixed
     */
    public function getValue($default = null)
    {
        return $this->getOption($this->valueProperty, 0);
    }

    /**
     * {@inheritdoc}
     */
    protected function isValidValue($value)
    {
        return $value !== null;
    }

    /**
     * {@inheritdoc}
     */
    public function render(array $options = [], $showLabel = true, $showField = true, $showError = true)
    {
        if (! isset($options['attr'])) {
            $options['attr'] = [];
        }

        if (isset($options['attr']['class'])) {
            $options['attr']['class'] = $options['attr']['class'] . ' js-switch';
        } else {
            $options['attr']['class'] = 'js-switch';
        }

        return parent::render($options, $showLabel, $showField, $showError);
    }
}