<?php

namespace Ignite\Core\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Password;
use Ignite\Core\Entities\User;

// TODO: Move to Participant module?
class Enrolled extends Mailable
{
    use Queueable, SerializesModels;

    /** @var User */
    protected $user;

    /**
     * Create a new order submitted message instance.
     *
     * @param User $user
     */
    public function __construct($user)
    {
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $user = $this->user;
        $token = Password::createToken($user);

        $this->to($user->email);
        $this->subject(config('core.participant.emails.enrollment.subject'));
        $this->from(config('mail.from.address'), config('mail.from.name'));

        return $this->markdown(
            config('core.participant.emails.enrollment.template'),
            compact('user', 'token')
        );
    }
}
