<?php

namespace Ignite\Core\Contracts\Dashboard;

interface Line extends Chart
{
    /**
     * The key of the X-Axis in the data.
     *
     * @return string
     */
    public function getXKey();

    /**
     * The keys of the Y-Axis in the data.
     *
     * @return string
     */
    public function getYKeys();

    /**
     * The color of the stat.
     *
     * @return string
     */
    public function getColors();

    /**
     * The HTML class of an icon.
     *
     * @return string
     */
    public function getIcon();

    /**
     * Get the Y axis labels.
     *
     * @return array
     */
    public function getLabels();
}