<?php

namespace Ignite\Core\Providers;

use Ignite\Core\Http\ViewComposers\GroupsDropdownComposer;
use Ignite\Core\Http\ViewComposers\NavigationMenuComposer;
use Ignite\Core\Http\ViewComposers\ParticipantMenuComposer;
use Ignite\Core\Http\ViewComposers\UserNavigationMenuComposer;
use Illuminate\Support\ServiceProvider;
use Ignite\Core\Http\ViewComposers\AdminMenuComposer;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Frontend: Navigation Menu
        view()->composer('partials._components.header', NavigationMenuComposer::class);

        // Frontend: User Navigation Menu
        view()->composer('partials._components._user-menu', UserNavigationMenuComposer::class);

        // Backend: Navigation Menu
        view()->composer('Core::layouts.page', AdminMenuComposer::class);

        // Backend: Participant Menu
        view()->composer('Core::partials.menu', ParticipantMenuComposer::class);

        // Backend: Groups Checkboxes
        view()->composer('Core::admin.cms.partials.form.groups', GroupsDropdownComposer::class);

        // Backend: Import Form
        view()->composer(
            ['Core::admin.import.partials.form'],
            \Ignite\Core\Http\ViewComposers\ImportForm::class
        );

        // Backend: Recent Imports
        view()->composer(
            ['Core::admin.import.partials.table'],
            \Ignite\Core\Http\ViewComposers\RecentImports::class
        );
    }
}
