<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
//use Ignite\Core\Database\IgniteMigration;

class CreateCoreTransactionTable extends Migration
{
    protected $tableName = 'core_transaction';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('related_id');
            $table->string('related_type', 255)->nullable()->default(null);
            $table->string('type', 50)->default('');
            $table->string('description')->nullable()->default(null);
            $table->double('value')->nullable()->default(null);
            $table->text('notes')->nullable()->default(null);
            $table->timestamp('tax_date')->nullable()->default(null);
            $table->string('related_name', 50)->nullable()->default(null);
            $table->dateTime('transaction_date');
            $table->softDeletes('deleted_at');
            $table->timestamps();
            $table->index('related_id');
            $table->index('type');
            $table->foreign('user_id')->references('user_id')->on('core_user')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
