<?php

namespace Ignite\Core\Helpers;

use Illuminate\Foundation\Application;
use Illuminate\Support\Traits\Macroable;

class Format
{
    use Macroable;

    /**
     * @var Application
     */
    protected $app;

    /**
     * Format constructor.
     *
     * @param Application $app
     */
    public function __construct(Application $app)
    {
        $this->app = $app;
    }

    /**
     * Format a date.
     *
     * @param string $value
     * @param string $format
     * @param string $default
     *
     * @return false|string
     */
    public function date($value, $format = 'm/d/Y', $default = '')
    {
        return $this->app->make(Date::class, compact('value'))->format($format, $default);
    }

    /**
     * Format a datetime.
     *
     * @param string $value
     * @param string $format
     * @param string $default
     *
     * @return false|string
     */
    public function datetime($value, $format = 'm/d/Y', $default = '')
    {
        return $this->app->make(DateTime::class, compact('value'))->format($format, $default);
    }

    /**
     * Format an amount.
     *
     * @param int|float|string $value
     * @param int $decimals
     * @param int $default
     *
     * @return mixed
     */
    public function amount($value, $decimals = 0, $default = 0)
    {
        return $this->app->make(Amount::class, compact('value'))->format($decimals, $default);
    }

    /**
     * Format a currency.
     *
     * @param int|float|string $value
     * @param string $currency
     * @param int $decimals
     * @param int $default
     *
     * @return mixed
     */
    public function currency($value, $currency, $decimals = 0, $default = 0)
    {
        return $this->app->make(Currency::class, compact('value', 'currency'))->format($decimals, $default);
    }
}
