<?php

namespace Ignite\Core\Database\Seeders;

use Ignite\Core\Entities\UserGroup;

class UserGroupsTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        /* TODO: Create a repository class for UserGroup
        $userGroupRepository = app(UserGroupRepository::class); */
        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('core_user_group.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                UserGroup::create($source);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
