<?php

namespace Ignite\Core\Providers;

use Ignite\Core\Events\Subscribers\Theme\Scaffold;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Ignite\Core\Events\User;
use SocialiteProviders\Manager\SocialiteWasCalled;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        SocialiteWasCalled::class => [
            '\\SocialiteProviders\\SalesForce\\SalesForceExtendSocialite@handle'
        ],
    ];

    /**
     * The subscriber classes to register.
     *
     * @var array
     */
    protected $subscribe = [
        User::class,
        Scaffold::class
    ];
}
