<?php

namespace Ignite\Core\Models\Dashboard\Charts;

use Ignite\Core\Services\Google\Analytics\Client;

class UniqueSessionsStat extends BaseGoogleAnalyticsMetric
{
    /**
     * @inheritDoc
     */
    public function __construct(Client $analytics, $attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Unique Visitors',
        ], $attributes);

        parent::__construct($analytics, $attributes);
    }


    /**
     * @inheritDoc
     */
    public function getElement()
    {
        return $this->get('key', 'unique-sessions-stat');
    }

    /**
     * @inheritDoc
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        return $this->prepareData('sessions');
    }

    /**
     * @inheritDoc
     */
    protected function decorate($value)
    {
        return number_format($value);
    }
}
