<?php

namespace Ignite\Core\Models\Dashboard\Charts;

use Ignite\Core\Services\Google\Analytics\Client;

class AverageSessionDurationStat extends BaseGoogleAnalyticsMetric
{
    /**
     * Create a new stat instance.
     *
     * @param array|object $attributes
     * @param Client $analytics
     */
    public function __construct(Client $analytics, $attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Average duration',
        ], $attributes);

        parent::__construct($analytics, $attributes);
    }


    /**
     * @inheritDoc
     */
    public function getElement()
    {
        return $this->get('key', 'average-duration-stat');
    }

    /**
     * @inheritDoc
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        return $this->prepareData('avgSessionDuration');
    }

    /**
     * @inheritDoc
     */
    protected function decorate($value)
    {
        $hours = floor($value / 3600);
        $mins = floor($value / 60 % 60);
        $secs = floor($value % 60);

        return sprintf('%02d:%02d:%02d', $hours, $mins, $secs);
    }
}
