@extends('Core::layouts.participant')
@section('page_heading', $pageTitle = sprintf('#%s - %s', $participant->getId(), $name = $participant->getFullName()))
@section('page_breadcrumb', $pageTitle)
@section('page_content')
    <div class="form-horizontal">
        <div class="row form-affix-container">
            @include('Core::partials.menu')
            <div class="col-sm-9 form-affix-body">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h2 class="box-title">{{ $name }}'{{ ends_with($name, 's') ? '' : 's' }} Transactions</h2>
                    </div>
                    <div class="box-body no-padding no-margin">
                        <div class="small-box bg-primary no-margin">
                            <div class="inner">
                                <h3 class="no-margin">{{ Format::balance($balance) }}</h3>
                                <p class="no-margin">Balance</p>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="transaction-add">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title">Create a transaction for {{ $name }}</h4>
                </div>
                <div class="modal-body">
                    @include('Core::admin.transactions.partials.form', ['participant' => $participant])
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    text: '<span class="fa fa-plus text-success"></span> <span class="text-success">Create</span>',
                    action: function (e) {
                        e.preventDefault();
                        var $dialog = $('#transaction-add');
                        $dialog.modal('show', function () {
                            $('.datepicker').datepicker({
                                format: 'mm/dd/yyyy',
                                autoclose: true
                            }).on('show.bs.modal', function(event) {
                                event.stopPropagation();
                            });
                            $('#adjustment').validate();
                        });
                    }
                }]
            });

            $.deleteEntry({
                confirmation: 'Are you sure you want to delete this transaction?',
                request: { method: 'GET', type: 'json' },
                onSuccess: function(button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function() {
                            $(this).remove();
                            $('#dataTableBuilder').DataTable().ajax.reload();
                        });
                }
            });
        });
    </script>
@endsection
