@extends('Core::layouts.main')

@section('meta_title', 'Dashboard')

@section('heading')
	<div class="clearfix">
        <h1 class="pull-left" style="font-size: 24px; margin-top: 0; position: relative; top: 3px;">Dashboard</h1>
        @unless (empty($dashboards))
        <div class="input-group pull-left" style="max-width: 400px; margin-left: 25px;">
            <form name="views" method="GET" action="{{ route('admin.dashboard.index') }}">
                <select title="Choose Dashboard View" onchange="forms.views.submit()" name="dashboard" id="dashboard" class="select2 pull-left" style="min-width: 200px;">
                    @foreach ($dashboards as $value)
                        <option {{ $value === $dashboard ? 'selected' : '' }} value="{{ $value }}">{{ $value }} Dashboard</option>
                    @endforeach
                </select>
            </form>
        </div>
        @endunless
        <div id="date-range-picker" class="input-group pull-left" style="max-width: 220px; margin-left: 25px;">
            <input type="text" id="daterange" name="daterange" value="{{ $start->format('m/d/Y') }} - {{ $end->format('m/d/Y') }}" class="form-control" />
            <div class="input-group-addon">
                <span class="fa fa-calendar"></span>
                <span class="caret"></span>
            </div>
        </div>
    </div>

@endsection

@section('page_content')

	<div class="row">
        @forelse ($charts as $chart)
            @component("Core::admin.dashboard.components.{$chart->getType()}", $chart->toArray())@endcomponent
        @empty
            <div class="col-xs-12"><p>No charts available.</p></div>
        @endforelse
    </div>
@stop

@section('css')
	@parent
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css" />
@endsection

@section('js')
@parent
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery.matchHeight/0.7.2/jquery.matchHeight-min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/raphael/2.2.7/raphael.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>
<script type="text/javascript">
    jQuery(function($) {
      $('#date-range-picker').daterangepicker({
        ranges: {
          'Last 7 Days': [moment().subtract(7, 'days'), moment()],
          'Last 30 Days': [moment().subtract(30, 'days'), moment()],
          'Last 60 Days': [moment().subtract(60, 'days'), moment()],
          'WTD': [moment().startOf('week'), moment()],
          'MTD': [moment().startOf('month'), moment()],
          'QTD': [moment().startOf('quarter'), moment()],
          'YTD': [moment().startOf('year'), moment()]
        },
        startDate: "{{ $start->format('m/d/Y') }}",
        endDate: "{{ $end->format('m/d/Y') }}",
        opens: 'right',
        drops: 'down',
        alwaysShowCalendars: true,
      }, function(start, end, label) {
        if (start !== 'Invalid date' && end !== 'Invalid date') {
            $('#daterange').val(start.format('MM/DD/YYYY') + ' - ' + end.format('MM/DD/YYYY'));
            window.location.href = '/admin?start=' + start.format('YYYY-MM-DD') + '&end=' + end.format('YYYY-MM-DD');
        }
      });

      var types = ['.chart-stat', '.chart-correlated-stat', '.chart-donut', '.chart-line', '.chart-table'];
      for (var i = 0; i <= types.length; i++) {
        var type = types[i];
        var elements = $(type);
        var tallest = $(type).first();
        for (var j = 0; j <= elements.length; j++) {
          var next = $(elements[j]);
          if (tallest.height() <= next.height()) {
            tallest = next;
          }
        }
        $(type).matchHeight({
          byRow: false,
          property: 'min-height',
          target: tallest,
          remove: false
        });
      }
    });
</script>
@endsection
