<?php

namespace Ignite\Core\Models\Dashboard\Charts;

use Ignite\Core\Services\Google\Analytics\Client;

class BounceRateStat extends BaseGoogleAnalyticsMetric
{
    /**
     * Create a new stat instance.
     *
     * @param array|object $attributes
     * @param Client $analytics
     */
    public function __construct(Client $analytics, $attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Bounce Rate',
        ], $attributes);

        parent::__construct($analytics, $attributes);
    }

    /**
     * @inheritDoc
     */
    public function getElement()
    {
        return $this->get('key', 'bounce-rate-stat');
    }

    /**
     * @inheritDoc
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        return $this->prepareData('bounceRate');
    }


    /**
     * @inheritDoc
     */
    protected function decorate($value)
    {
        return number_format($value, 2) . '%';
    }
}
