
    <div class="col-md-{{ auth()->user()->can('core.import.create') ? '8' : '12' }}">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Recent Imports</h3>
            </div>
            <div class="box-body no-padding">
                <table class="table table-striped table-imports">
                    <thead>
                    <tr>
                        <th width="103" nowrap>Actions</th>
                        <th width="100">Status</th>
                        <th>Created At</th>
                        <th>Created By</th>
                        <th>Type</th>
                        <th>File</th>
                        <th>Records</th>
                        <th>Run By</th>
                        <th>Run At</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse ($imports as $import)
                        <tr>
                            <td>
                                @can('core.import.view')
                                <div class="btn-group">
                                    <a href="{{ route('admin.import.show', $import) }}" class="btn btn-default btn-sm">
                                        <span class="fa fa-eye"></span> View
                                    </a>
                                    @can('core.import.delete')
                                    <button class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a href="{{ route('admin.import.destroy', $import) }}" class="delete-entry">
                                                <span class="fa fa-trash text-danger"></span>
                                                <span class="text-danger">Delete</span>
                                            </a>
                                        </li>
                                    </ul>
                                    @endcan
                                </div>
                                @endcan
                            </td>
                            <td>
                                {{ $import->getStatusLabel() }}
                            </td>
                            <td>{{ $import->getCreatedAt()}}</td>
                            <td>{{ $import->getCreatedBy() }}</td>
                            <td>{{ $import->getTypeLabel() }}</td>
                            <td>@if ($import->file){{ $import->file }} @else <span class="label label-danger">Missing File</span> @endif</td>
                            <td>{{ $import->records }}</td>
                            <td>{{ $import->getRunBy() }}</td>
                            <td>{{ $import->getRunAt() }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center">No imports uploaded yet.</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
