<?php

namespace Ignite\Core\Models\Dashboard;

use Ignite\Core\Contracts\Dashboard\Stat as StatInterface;

abstract class Stat extends Chart implements StatInterface
{
    /**
     * The color of the stat.
     *
     * @return string
     */
    public function getColor()
    {
        return $this->get('color');
    }

    /**
     * The link to see more information about the stat.
     *
     * @return string
     */
    public function getLink()
    {
        return $this->get('link');
    }

    /**
     * The HTML class of an icon.
     *
     * @return string
     */
    public function getIcon()
    {
        return $this->get('icon');
    }

    /**
     * The simple name of the type of stat.
     *
     * @return string
     */
    public function getType()
    {
        return $this->get('type', 'stat');
    }
}
