<?php

namespace Ignite\Core\Http\Forms;

use Ignite\Core\Models\Form\Form;

class ProfileForm extends Form
{
    /**
     * Should the values be grouped by table.
     * @var bool
     */
    protected $groupByTable = true;

    /**
     * Build the enrollment form.
     *
     * @return mixed|void
     * @throws \Exception
     */
    public function buildForm()
    {
        $this->buildFromSchema('enrollment', $this->getData('renderGroups', true));

        if (isset($this->data['readonly'])) {
            /** @var \Kris\LaravelFormBuilder\Fields\FormField $field */
            foreach ($this->fields as $field) {
                $field->setOption('attr.readonly', true);

                if ($choices = $field->getOption('choices')) {
                    $field->disable();
                }

                if (in_array($field->getType(), ['button', 'submit', 'reset'])) {
                    $this->remove($field->getName());
                }
            }
        }
    }
}
