<?php

namespace Ignite\Composer\Themes;

use Composer\Package\PackageInterface;
use Composer\Installer\LibraryInstaller;

class ThemeInstaller extends LibraryInstaller
{
    /**
     * {@inheritDoc}
     */
    public function supports($packageType)
    {
        return 'ignite-theme' === $packageType;
    }

    /**
     * {@inheritDoc}
     */
    public function getInstallPath(PackageInterface $package)
    {
        $this->initializeVendorDir();

        $basePath = rtrim($this->vendorDir ? $this->vendorDir : '', DIRECTORY_SEPARATOR);

        list($parent, $package) = explode('/', $package->getPrettyName());

        $prefix = 'theme-';
        if (substr($package, 0, strlen($prefix)) === $prefix) {
            $theme = substr($package, strlen($prefix));
        } else {
            $theme = $package;
        }

        return implode(DIRECTORY_SEPARATOR, [$basePath, $parent, 'themes', $theme]);
    }
}
