<?php

namespace Ignite\Composer\Modules;

use Composer\Package\PackageInterface;
use Composer\Installer\LibraryInstaller;

class ModuleInstaller extends LibraryInstaller
{
    /**
     * {@inheritDoc}
     */
    public function supports($packageType)
    {
        return 'ignite-module' === $packageType;
    }

    /**
     * {@inheritDoc}
     */
    public function getInstallPath(PackageInterface $package)
    {
        $this->initializeVendorDir();

        $basePath = rtrim($this->vendorDir ? $this->vendorDir : '', DIRECTORY_SEPARATOR);

        list($parent, $module) = explode('/', $package->getPrettyName());

        $moduleName = str_replace(' ', '', ucwords(str_replace('-', ' ', mb_strtolower($module))));

        return implode(DIRECTORY_SEPARATOR, [$basePath, $parent, 'modules', $moduleName]);
    }
}
