<?php

namespace Ignite\Claim\Models;

class IgniteUtility
{
    /**
     * This routine returns a string of $count random digits whose
     * minimum value is $min and maximum value is $max.
     *
     * @param int $count
     * @param int $min
     * @param int $max
     * @return string
     */
    public static function randomDigits($count, $min = 0, $max = 9)
    {
        // All of the seed stuff is to prevent repetition.
        // Time is not resolute enough during the execution
        // to guaranty a new random sequence on subsequent calls.
        static $seed = 0;

        // Verify input params
        if ($max < 1 || $max > 15) {
            $max = 15;
        }

        if ($min < 0 || $min > ($max - 1)) {
            $min = 0;
        }

        // Establish random seed
        if ($seed == 0) {
            list($usec, $sec) = explode(" ", microtime());
            $seed = $usec * 1000000;
            mt_srand($seed);
        }

        $string = '';
        for ($ii=0; $ii<$count; ++$ii) {
            $string .= mt_rand($min, $max);
        }

        return $string;
    }

    /**
     * This routine returns a string of random hexadecimal digits
     * whose value is minimum value  is $min and maximum value is $max.
     *
     * @param int $count
     * @param int $min
     * @param int $max
     * @return string
     */
    public static function randomHexDigits($count, $min = 0, $max = 15)
    {
        // All of the seed stuff is to prevent repetition.
        // Time is not resolute enough during the execution
        // to guaranty a new random sequence on subsequent calls.
        static $seed = 0;
        static $hexDigits = "0123456789ABCDEF";

        // Check for Hex chars
        $max = strtoupper($max);
        if ($max >= "A" && $max <= "F") {
            $max = hexdec($max);
        }

        $min = strtoupper($min);
        if ($min >= "A" && $min <= "F") {
            $min = hexdec($min);
        }

        // Verify input parms
        if ($max < 1 || $max > 15) {
            $max = 15;
        }

        if ($min < 0 || $min > ($max - 1)) {
            $min = 0;
        }

        // Establish random seed
        if ($seed == 0) {
            list($usec, $sec) = explode(" ", microtime());
            $seed = $usec * 1000000;
            mt_srand($seed);
        }

        $string = '';
        for ($ii=0; $ii<$count; ++$ii) {
            $string .= $hexDigits[mt_rand($min, $max)];
        }

        return $string;
    }

    /**
     * Obfuscate an ID.
     *
     * @param  int $id
     * @return string
     */
    public static function obfuscateId($id)
    {
        $idHex = self::randomHexDigits(2, 4) . sprintf("%04x", $id);

        $obfuscated = '';
        $separator = '';

        for ($ii = 0; $ii < 4; ++$ii) {
            $hexDigits = self::randomHexDigits(rand(4, 6));
            if ($ii == 0) {
                $idPosition = (hexdec($hexDigits[2]) % 3) + 1;
            }
            if ($ii == $idPosition) {
                $obfuscated .= $separator . $idHex;
            } else {
                $obfuscated .= $separator . $hexDigits;
            }
            $separator = '-';
        }

        return $obfuscated;
    }

    /**
     * Unobfuscate a string containing an obfuscated ID.
     *
     * @param  string $obfuscated
     * @return float|int
     */
    public static function unobfuscateId($obfuscated)
    {
        $parts = explode('-', $obfuscated);
        $idPosition = (hexdec($parts[0][2]) % 3) + 1;

        $id = hexdec(substr($parts[$idPosition], -4));

        return $id;
    }
}
