
    function updateRowCount(countFieldName, tableName)
    {
        var count = 0;

        $('#' + tableName + ' tbody tr[data-column_name]').each(function() {
            ++count;
        });

        $('#' + countFieldName).html(count);
    }

    function showHideNoRows(countFieldName, tableName, message)
    {
        var count = $('#' + countFieldName).html();

        if ( count == 0 ) {
            var html = '';
            html += '<tr class="noRows">' + "\n";
            html += '    <td colspan="10">' + message + '</td>' + "\n";
            html += '</tr>' + "\n";

            $('#' + tableName + ' tbody').html(html);
        }
        else {
            $('#' + tableName + ' tbody tr.noRows').remove();
        }
    }

    function setFormField($formField, name, value, showAlerts)
    {
        if ( $formField.length == 0 ) {
            if ( typeof(showAlerts) != 'undefined' && showAlerts ) {
                alert("PopulateEditColumnDialog: Unknown field name '" + name + "'");
            }
            return false;
        }

        var tagName = $formField.prop('tagName');

        switch(tagName)
        {
            case 'INPUT':
                if ( $formField.prop('type') == 'checkbox' )
                    $formField.prop('checked', (( value > 0 ) ? 1 : 0));
                else
                    $formField.val(value);
                break;

            case 'SELECT':
                // Always return the Name instead of the Value
                $formField.find("option").filter(function() {
                        return $(this).text() == value; 
                    }).prop('selected', true);

                $formField.trigger('change');
                break;

            case 'DIV':
            case 'TH':
            case 'TD':
                $formField.html(value);
                if ( $formField.attr('data-boolean') )
                    $formField.html( (( value > 0 ) ? 'Yes' : 'No') );
                else
                    $formField.html(value);
                break;

            case 'TEXTAREA':
                $formField.val(value);
                break;

            default:
                alert("PopulateEditColumnDialog: Unknown field type '" + $formField.prop('tagName') + "' for field name '" + name + "'");
                return false;
                break;
        }

        return true;
    }

    function retrieveEditColumnDialog(params, dialogName)
    {
        var data = {};

        // ----------------------------------------
        // Retrieve the data from the Edit Column Dialog
        // Use the Form Fields list in case the List has changed
        // ----------------------------------------
        for (var name in formFields) {
            var value = ( typeof(params[name]) != 'undefined' ) ? params[name] : '';
            var $formField = $('#' + dialogName).find('[data-name="' + name + '"]').not('.hidden');
            var tagName = $formField.prop('tagName');

            if ( $formField.length == 0 ) {
                alert("retrieveEditColumnDialog: Unknown field name '" + name + "'");
                continue;
            }

            switch(tagName)
            {
                case 'INPUT':
                    if ( $formField.prop('type') == 'checkbox' )
                       data[name] = ( $formField.prop('checked') ) ? 1 : 0;
                    else
                       data[name] = $formField.val();
                    break;

                case 'SELECT':
                    var $option = $formField.find('option:selected');
                    // Handle Value=>Text, vs Text only in select
                    // Also handle special case of none selected ie: "--- select ---"
                    if ( $option.val() != $option.text() && $option.val() != '' )
                        data[name] = $option.text();
                    else
                        data[name] = $option.val();
                    break;

                case 'DIV':
                case 'TH':
                case 'TD':
                    data[name] = $formField.html();
                    break;

                case 'TEXTAREA':
                       data[name] = $formField.val();
                    break;

                default:
                    alert("retrieveEditColumnDialog: Unknown field type '" + $formField.prop('tagName') + "' for field name '" + name + "'");
                    break;
            }
        }

        return data;
    }

    function populateEditColumnDialog(params, dialogName)
    {
        var showAlerts = true;

        // ----------------------------------------
        // Populate the Edit Column Dialog with the values from the Column Line selected
        // Use the Form Fields list in case the List has changed
        // ----------------------------------------
        for (var name in formFields) {
            var value = ( typeof(params[name]) != 'undefined' ) ? params[name] : '';
            var $formField = $('#' + dialogName).find('[data-name="' + name + '"]').not('.hidden');

            var rc = setFormField($formField, name, value, showAlerts);
        }
    }
