<?php

namespace Ignite\Claim\Models\Grid;

class TrashedTable extends ClaimTable
{
    /**
     * The forms to look up for extra columns.
     * @var array
     */
    protected $forms = [
        'form.claim.partial.claim_fields_external',
        //'form.claim.partial.claim_fields_internal',
    ];

    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [
        'idc', 'id'
    ];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [
        'checkbox', 'actions', 'claim_id', 'date_submitted', 'status', 'first', 'last',
        'participant_type', 'participant_email', 'value'
    ];

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns(): array
    {
        $columns = array_merge([
            'checkbox' => $this->checkboxColumn(),
            'deleted_at' => $this->deletedAtColumn()
        ], parent::columns());

        unset($columns['action']);

        return $columns;
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('actions', 'checkbox')
            ->keys()->toArray();

        $query = $this->getConnection()->table('claim_participant')
            ->select($columns)
            ->distinct()
            ->leftJoin('claim', 'claim.id', '=', 'claim_participant.claim_id')
            ->leftJoin('core_participant AS participant', 'participant.user_id', '=', 'claim_participant.user_id')
            ->leftJoin('core_user', 'core_user.user_id', '=', 'claim_participant.user_id')
            ->whereNotNull('claim_participant.deleted_at');

        return $this->applyScopes($query);
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap(): array
    {
        return [
            'checkbox' => function ($model) { return $this->formatter->checkbox($model); },
            'action' => function ($model) { return $this->formatter->actions($model); },
            'status' => function ($model) { return $this->formatter->status($model); },
            'date_submitted' => function ($model) { return $this->formatter->submittedAt($model); },
            'activity_date' => function ($model) { return $this->formatter->activityAt($model); },
            'participant_email' => function ($model) { return $this->formatter->participantEmail($model); },
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters(): array
    {
        $params = parent::getBuilderParameters();

        return array_merge($params, [
            'order'   => [[1, 'asc']],
            'buttons' => [
                'postCsv'
            ],
            'select' => [
                'info' => true,
                'style' => 'multi',
                'selector' => 'td:first-child'
            ],
            'columnDefs' => [
                ['targets' => 0, 'checkboxes' => ['selectRow' => true]]
            ]
        ]);
    }
}
