@php
    $line = $formData['claim_items'] ?? [];
    $selectedData = collect($line);
    $selected = explode(',', $selectedData->pluck('offer_id')->first());
    $selectedNames = $selectedData->pluck('name')->toArray();
    $minQuantity = \Ignite\Claim\Facades\Settings::find('claim.lineitems.min_quantity');
    $maxQuantity = \Ignite\Claim\Facades\Settings::find('claim.lineitems.max_quantity');
@endphp
<input type="hidden" id="claimItemAction" value="">
<div class="row">
    <div class="col-md-6" id="claim-items-checkboxes">
        @php $groups = array_keys($offerGroups); @endphp
        <label for="claimItemName">{{ __('Claim::claim.items.name') }} <em class="field-is-required text-danger">*</em></label>

        @if (count($offerGroups) > 1 || ! isset($offerGroups[$groups[0]]) || count($offerGroups[$groups[0]]) <= 1)
            <div class="alert alert-danger">
                <p>The offers checkbox template only supports one group</p>
            </div>
        @else
            @foreach ($offerGroups[$groups[0]] as $offer)
            <div class="checkbox">
                <label>
                    <input data-name="{{ $offer['name'] }}" data-offer-group="{{ $groups[0] }}" type="checkbox" name="claimCheckboxes" id="claim-checkboxes" data-name="name" value="{{ $offer['offer_id'] }}" {{ in_array($offer['offer_id'], $selected) ? ' checked' : '' }} /> {{ $offer['name'] }}
                </label>
            </div>
            @endforeach
            <input type="hidden" class="form-control" id="claimItemId" name="claim_items[0][id]" data-name="id" value="{{ isset($line['id']) ? $line['id'] : 'new' }}" />
            <input type="hidden" class="form-control" id="claimItemOfferId" name="claim_items[0][offer_id]" data-name="offer_id" value="{{ implode(',', $selected) }}" />
            <input type="hidden" class="form-control" id="claimItemOfferName" name="claim_items[0][name]" data-name="name" value="{{ implode('|', $selectedNames) }}" />
            <input type="hidden" class="form-control" id="claimItemOfferGroup" name="claim_items[0][offer_group]" data-name="offer_group" value="{{ $groups[0] }}" />
            <input type="hidden" class="form-control" id="claimItemQty" name="claim_items[0][qty]" data-name="qty" value="{{ isset($line['qty']) ? $line['qty'] : $minQuantity }}" />
        @endif
    </div>
</div>
