<?php

namespace Ignite\Claim\Models\Options;

use Ignite\Core\Contracts\Source;

class DeclineReasons implements Source
{
    /**
     * The source as a key-value pair array with the value as the key and the label as the value.
     *
     * @return array
     */
    public function toDropdown()
    {
        $reasons = config('claim.decline.reasons', []);
        $otherOption = config('claim.decline.other');
        $emptyReason = config('claim.decline.empty');
        $dropdown = [];

        if (empty($reasons)) {
            return $dropdown;
        }

        if ($emptyReason && ! $otherOption) {
            $dropdown[''] = $emptyReason;
        }

        foreach ($reasons as $key => $value) {
            if ($key === '' || $value === '') {
                continue;
            }

            if (is_int($key)) {
                $key = $value;
            }

            $dropdown[$key] = $value;
        }

        if (!empty($reasons) && ! empty($otherOption)) {
            $dropdown['other'] = $otherOption;
        }

        return $dropdown;
    }
}
