<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class RuleParticipant extends Model
{
    use ValidatesFields;

    /**
     * The table name.
     * @var string
     */
    protected $table = 'claim_rule_participant';

    /**
     * The primary key.
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * The field declarations.
     * @var array
     */
    public static $fields = [
        'id'                    => ['type' => 'integer'],
        'rule_id'               => ['type' => 'integer'],
        'participant_type'      => ['type' => 'string'],
    ];

    /**
     * The relationship to the Rule model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function rule()
    {
        return $this->belongsTo('Ignite\Claim\Entities\Rule', 'rule_id');
    }
}
