<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class OfferCampaign extends Model
{
    use ValidatesFields;

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    /** @var string */
    protected $table = 'claim_offer_campaign';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    public static $fields = [
        'id'          => ['type' => 'integer'],
        'name'        => ['type' => 'string'],
        'description' => ['type' => 'string'],
        'start_date'  => ['type' => 'date'],
        'end_date'    => ['type' => 'date'],
        'status'      => ['type' => 'integer', 'default' => '0'],
    ];

    /**
     * The relationship to the promotions.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function promotions()
    {
        return $this->hasMany('Ignite\Claim\Entities\OfferPromotion', 'campaign_id', 'id');
    }

    /**
     * Determine if the offer has any related promotions.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function hasPromotions()
    {
        return $this->hasMany('Ignite\Claim\Entities\OfferPromotion', 'campaign_id', 'id')
            ->select(['campaign_id', 'id']);
    }

    /**
     * Scope a query to only include active campaigns.
     *
     * @param $query
     */
    public function scopeOnlyActive($query)
    {
        $query->where('status', static::STATUS_ACTIVE);
    }
}
