@extends('Claim::layouts.entry')

@php
    $title = ($mode == 'new' ? 'Create Claim' : 'Edit Claim #' . $formData['claim_id'] . ' (Claim Participant #' . $formData['claim_participant']['id'] . (isset($formData['claim_participant']['participant']) ? ' - '.$formData['claim_participant']['participant']['first'] . ' ' . $formData['claim_participant']['participant']['last'] : '') .')');
@endphp

@section('page_heading', $title)

@section('page_breadcrumb', $title)

@section('page_content')
    <div class="row">
        <div class="col-md-3">
            @include('Claim::admin.partials.menu', ['formData' => $formData])
            @include('Claim::admin.partials.participant', ['participant' => $formData['claim_participant']['participant'] ?? []])
        </div>
        <div class="col-sm-9">
            <div class="box box-primary">
                <div class="box-body">
                    <div class="tab-pane active" id="form-content">
                        @include('Claim::partials.claimForm')
                        @include('Claim::partials.claimItemDialog_static')
                        @include('Claim::partials.claimParticipantDialog_static')
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script>
        var offerGroups = {!! json_encode($offerGroups, JSON_PRETTY_PRINT) !!};
        var dirtyFlag = false;
    </script>
    <script src="{{ asset('/vendor/ignite/js/claim/newClaim.js') }}"></script>
    <script src="{{ asset('/vendor/ignite/js/claim/newClaimItem.js') }}"></script>
    <script src="{{ asset('/vendor/ignite/js/claim/newClaimParticipant.js') }}"></script>
@endsection
