<?php

namespace Ignite\Claim\Models\Dashboard\Charts;

use Illuminate\Database\Query\Builder;

class ClaimsDeclinedStat extends ClaimMetric
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Claims declined',
            'color' => 'red',
            'link'  => url('/admin/claim/list/declined'),
            'sort'  => 4
        ], $attributes);

        parent::__construct($attributes);
    }

    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'claims-declined-stat';
    }

    /**
     * Scope the query to include approved claims only.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    protected function scope(Builder $query)
    {
        return $query->where('status', '=', 'declined');
    }
}
