
$(document).ready(function(){

    'use strict';

    function clearClaimParticipantDialog()
    {
        claimParticipantValidator.resetForm();
        $('#claimParticipantDialog [data-name]').removeClass('error');
        $('#claimParticipantEmail').val('');
        $('#claimParticipantEmail').trigger('blur');
        if ($('select#claimParticipantType').length > 0) {
            $('select#claimParticipantType').val('');
            $('select#claimParticipantType').trigger('change');
        }
    }
    
    function getClaimParticipantCount()
    {
        return $('#claimParticipantsList tr.claimParticipant').length;
    }

    function updateClaimParticipantCount()
    {
        $('#claimParticipantCount').html(getClaimParticipantCount);
    }

    function checkMaxParticipantCount()
    {
        var maxParticipantCount = $('#maxParticipants').val();

        if (maxParticipantCount !== '' && getClaimParticipantCount() >= parseInt(maxParticipantCount, 10)) {
           alert('You are only allowed to enter up to ' + maxParticipantCount + ' Additional Participants.');
           return false;
        }

        return true;
    }

    function setClaimParticipantButtons(mode)
    {
        $('#claimParticipantDialog .modal-header').removeClass('bg-default');
        $('#claimParticipantDialog .modal-header').removeClass('bg-success');

        if (mode == 'add') {
            $('#claimParticipantDialog .modal-header').addClass('bg-success');
            $('#claimParticipantLabel').html('Add Claim Participant');
            $('#claimParticipantSave').addClass('hidden');
            $('#claimParticipantSave').hide();
            $('#claimParticipantAdd').removeClass('hidden');
            $('#claimParticipantAdd').show();
        } else {
            $('#claimParticipantDialog .modal-header').addClass('bg-default');
            $('#claimParticipantLabel').html('Edit Claim Participant');
            $('#claimParticipantAdd').addClass('hidden');
            $('#claimParticipantAdd').hide();
            $('#claimParticipantSave').removeClass('hidden');
            $('#claimParticipantSave').show();
        }
    }

    function deleteClaimParticipant(element)
    {
        $(element).closest('tr').remove();

        updateClaimParticipantCount();
    }

    function buildClaimParticipantRow(count)
    {
        var html = '<tr class="claimParticipant">';
            html += '<td name="lineNumber">' + count + '</td>';
            html += '<input type="hidden" name="id" value="new" />';

        $('#addClaimParticipantForm [data-name]').each(function() {
            var dataName = $(this).attr('data-name');
            var value = $(this).val();

            if ($(this).prop('tagName') == 'SELECT' && $(this).val() != $(this).find('option:selected').text()) {
                value = $(this).find('option:selected').text();
            }

            if ($(this).attr('type') == 'hidden') {
                html += '<input type="hidden" name="' + dataName + '" value="' + value + '" />';
            } else {
                html += '<td><input type="hidden" name="' + dataName + '" value="' + value + '" />' + value + '</td>';
            }
        });

        var editButton   = '<button type="button" class="btn btn-sm btn-default editClaimParticipant"><span class="text-info"><span class="fa fa-pencil"></span> Edit</span></button>' + "\n";
        var deleteButton = '<button type="button" class="btn btn-sm btn-default deleteClaimParticipant"><span class="text-danger"><span class="fa fa-trash"></span> Delete</span></button>' + "\n";

        html += "<td class='text-right'>" + editButton + deleteButton + "</td>";
        html += '</tr>';

        var $row = $(html);

        $row.find('.editClaimParticipant').click(function() {
            editClaimParticipant(this);
        });

        $row.find('.deleteClaimParticipant').click(function() {
            deleteClaimParticipant(this);
        });

        return $row;
    }

    function editClaimParticipant(element)
    {
        // Get the Claim Line Participant selected
        var $row = $(element).closest('tr');
        var lineNumber = $row.find('[name="lineNumber"]').html();

        clearClaimParticipantDialog();
        setClaimParticipantButtons('edit');

        $('#claimParticipantSave').attr('data-item_number', lineNumber);

        // Populate the Edit Claim Participant Dialog with the values from the Claim Line Participant selected
        $('#addClaimParticipantForm [data-name]').each(function() {
            var dataName = $(this).attr('data-name');
            var itemValue = $row.find('[name="'+dataName+'"]').val();
            $(this).val(itemValue);
            if ($(this).prop('tagName') == 'SELECT') {
                $(this).find("option").filter(function() {
                    return $(this).text() == itemValue; 
                }).prop('selected', true);
               $(this).trigger('change');
            }
        });

        $('#claimParticipantDialog').modal('show');
    }

    function validateClaimParticipant(mode, lineNumber)
    {
        if (! $("#addClaimParticipantForm").valid()) {
            return false;
        }

        var dialogEmail = $('#claimParticipantEmail').val().trim();
        var foundEmailLine = false;
        var count = 0;
        $('#claimParticipantsList tbody tr').each(function() {
            ++count;
            var email = $(this).find('input[name="participant_email"]').val();
            if ( (foundEmailLine == false && email.trim() == dialogEmail)
                && (mode == 'add' || count != lineNumber) ) {
                foundEmailLine = count;
            }
        });

        if (foundEmailLine) {
            alert(dialogEmail + ' is a Duplicate Email of:\nAdditional Participants Line # ' + foundEmailLine + '.');
            return false;
        }

        return true;
    }

    $('#claimParticipantAdd').click(function() {
        if (! checkMaxParticipantCount() || ! validateClaimParticipant('add', 0)) {
            return false;
        }
        var itemCount = $('#claimParticipantsList tbody tr').length + 1;

        $('#claimParticipantsList tbody').append(buildClaimParticipantRow(itemCount));

        updateClaimParticipantCount();
        clearClaimParticipantDialog();

        $('#claimParticipantDialog').modal('hide');
    });

    $('#claimParticipantSave').click(function() {
        // Get Participant Number that was being Edited from the Claim Line Participant Dialog
        var lineNumber = $('#claimParticipantSave').attr('data-item_number');

        if (! validateClaimParticipant('edit', lineNumber)) {
            return false;
        }

        // Build a new Row with the Data from the Claim Line Participant Dialog
        var $row = buildClaimParticipantRow(lineNumber);

        // Find the Claim Line Participant Dialog and replace it with the new Row
        var $claimLineParticipant = null;
        $('#claimParticipantsList tbody td[name="lineNumber"]').filter(function() {
            var html = $(this).html();
            if ( html == lineNumber ) {
                $claimLineParticipant = $(this).closest('tr');
                return false;
            }
        });

        $claimLineParticipant.replaceWith($row);

        $('#claimParticipantDialog').modal('hide');
    });

    $('#addClaimParticipant').click(function (event) {
        if (! checkMaxParticipantCount()) {
            return false;
        }

        clearClaimParticipantDialog();
        setClaimParticipantButtons('add');
        $('#claimParticipantDialog').modal('show');
    });

    $('.deleteClaimParticipant').click(function() {
        deleteClaimParticipant(this);
    });

    $('.editClaimParticipant').click(function() {
        editClaimParticipant(this);
    });

    $('#claimParticipantSelect').change(function() {
        var claimId = $('#claimForm #claim_id').val();
        var uri = '/admin/claim/edit/' + claimId + '/' + $(this).val();
        location.replace(uri);
    });

    $(document).off('show.bs.modal', '#claimParticipantDialog');

    var claimParticipantValidator = $('#addClaimParticipantForm').validate(window.validationConfig);
});
