<?php

namespace Ignite\Claim\Models\Grid;

use Ignite\Core\Models\Grid\Formatter;
use Ignite\Claim\Entities\OfferCampaign;

class PromotionFormatter extends Formatter
{
    /**
     * Custom column for actions.
     *
     * @param  \Ignite\Core\Entities\Participant $model
     * @return \Illuminate\Support\HtmlString
     */
    public function actions($model)
    {
        $actions = [
            [
                'click' => '',
                'class' => 'text-success',
                'icon' => 'plus',
                'label' => 'Create Claim',
                'text' => 'text-success',
                'type' => 'default',
                'link' => route('admin.claim.create', [
                    'promotionId' => $model->id
                ])
            ], [
                'click' => '',
                'class' => '',
                'icon' => 'pencil',
                'label' => 'Edit Promotion',
                'text' => '',
                'type' => 'default',
                'link' => route('admin.offer.show', [
                    'campaignId' => $model->campaign_id
                ])
            ]
        ];

        return $this->buttons($actions);
    }

    /**
     * Format the status column.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function status($model)
    {
        $status = [
            OfferCampaign::STATUS_ACTIVE => 'Active',
            OfferCampaign::STATUS_INACTIVE => 'Inactive',
        ];

        return $this->html($status[$model->status]);
    }

    /**
     * Format the date start column.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function startDate($model)
    {
        if (! $model->start_date || empty($model->start_date)) {
            return $this->html('N/A');
        }

        return $this->formatDate($model, 'start_date', 'm/d/Y');
    }

    /**
     * Format the date end column.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function endDate($model)
    {
        if (! $model->end_date || empty($model->end_date)) {
            return $this->html('N/A');
        }

        return $this->formatDate($model, 'end_date', 'm/d/Y');
    }
}
