<?php

namespace Ignite\Claim\Entities;

// TODO: Move to the Claim module
class Debug
{
    const LEVEL_ONE = 1;

    /** @var int */
    public $debugMode = 0;

    /** @var int */
    public $debugLevel = 0;

    /** @var int */
    public $detailLevel = 0;

    /** @var array */
    public $debugLog = [];

    /** @var bool */
    public $debugLastResult = false;

    /** @var string */
    public $debugLastMessage  = '';

    /**
     * Debug constructor.
     *
     * @param int $debugMode
     * @param int $debugLevel
     * @param int $detailLevel
     */
    public function __construct($debugMode = 0, $debugLevel = 0, $detailLevel = 10)
    {
        $this->debugMode = $debugMode;
        $this->debugLevel = $debugLevel;
        $this->detailLevel = $detailLevel;
    }

    /**
     * Reset the class properties to initial state.
     *
     * @note  I was unable to find any reference to usage of this method. Consider removing.
     * @param int $debugMode
     * @param int $debugLevel
     * @param int $detailLevel
     */
    public function reset($debugMode = 0, $debugLevel = 0, $detailLevel = 10)
    {
        $this->debugLevel = $debugMode;
        $this->debugMode = $debugLevel;
        $this->detailLevel = $detailLevel;
        $this->debugLog = [];
        $this->debugLastResult = false;
        $this->debugLastMessage = '';
    }

    /**
     * Add the log to the debug list and if the debugMode is not 0, print to screen.
     *
     * @param int $level
     * @param string $message
     * @return $this
     */
    public function logDebug($level, $message)
    {
        if ($this->debugLevel >= $level) {
            $this->debugLog[] = [
                'level' => $level,
                'message' => $message,
            ];

            if ($this->debugMode > 0) {
                printf("(%s) %s\n", $level, $message);
            }
        }

        return $this;
    }

    /**
     * Set the debug level.
     *
     * @param  int $debugLevel
     * @return $this
     */
    public function setDebugLevel($debugLevel)
    {
        if (! is_null($debugLevel) && is_int($debugLevel)) {
            $this->debugLevel = $debugLevel;
        }

        return $this;
    }

    /**
     * Set the debug mode.
     *
     * @param  int $mode
     * @return $this
     */
    public function setDebugMode($mode)
    {
        if (! is_null($mode) && is_int($mode)) {
            $this->debugMode = $mode;
        }

        return $this;
    }

    /**
     * Set the level of detail allowed in the log.
     *
     * @param  int $detailLevel
     * @return $this
     */
    public function setDebugDetailLevel($detailLevel = 10)
    {
        if (! is_null($detailLevel) && is_int($detailLevel)) {
            $this->detailLevel = $detailLevel;
        }

        return $this;
    }

    /**
     * Dump the log for debugging.
     *
     * @param bool $detailLevel
     */
    public function dumpDebugLog($detailLevel = false)
    {
        if ($detailLevel === false) {
            $detailLevel = $this->detailLevel;
        }

        foreach ($this->debugLog as $entry) {
            if ($entry['level'] < $detailLevel) {
                printf("(%s) %s\n", $entry['level'], $entry['message']);
            }
        }
    }

    /**
     * Get the debug level.
     *
     * @return int
     */
    public function getDebugLevel()
    {
        return $this->debugLevel;
    }

    /**
     * Get the debug mode.
     *
     * @return int
     */
    public function getDebugMode()
    {
        return $this->debugMode;
    }

    /**
     * Get the debug log.
     *
     * @return array
     */
    public function getDebugLog()
    {
        return $this->debugLog;
    }
}
