<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\SoftDeletes;
use Ignite\Claim\Entities\Dynamic\DynamicModel;
use Ignite\Claim\Traits\ValidatesFields;
use Ignite\Claim\Entities\Offer;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ClaimLineitem extends DynamicModel implements AuditableContract
{
    use Auditable, ValidatesFields, SoftDeletes;

    const TABLE_KEY = 'table.columns.claim_lineitem';

    /** @var string */
    protected $table = 'claim_lineitem';

    /** @var string */
    protected $primaryKey = 'id';

    /**
     * Should the timestamps be audited?
     *
     * @var bool
     */
    protected $auditTimestamps = false;

    /**
     * Custom Audit Driver
     *
     * @var \Ignite\Claim\Models\Audit\ClaimDriver
     */
    protected $auditDriver = \Ignite\Claim\Models\Audit\ClaimDriver::class;

    /**
     * Attributes to exclude from the Audit.
     *
     * @var array
     */
    protected $auditExclude = [
        'id',
        'updated_at',
        'created_at'
    ];

    public static $fields = [
        'id'            => ['type' => 'integer'],
        'claim_id'      => ['type' => 'integer'],
        'offer_id'      => ['type' => 'integer'],
        'status'        => ['type' => 'integer', 'default' => '0'],
        'offer_group'   => ['type' => 'string', 'default' => ''],
        'name'          => ['type' => 'string', 'validate' => 'required'],
        'qty'           => ['type' => 'integer', 'default' => '1', 'validate' => 'required|integer|min:1'],
        'multiplier'    => ['type' => 'float'],
        'value'         => ['type' => 'float'],
        'value_base'    => ['type' => 'float'],
    ];

    /**
     * The relationship to the claim.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function claim()
    {
        return $this->belongsTo(Claim::class, 'claim_id', 'id');
    }

    /**
     * The relationship to the offer.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function offer()
    {
        return $this->hasOne(Offer::class, 'id', 'offer_id');
    }

    /**
     * The identifier for the record in the audit log.
     *
     * @return mixed
     */
    public static function getAuditFriendlyField()
    {
        return ['name', 'offer_group'];
    }

    /**
     * The character to used to join two audit fields.
     *
     * @return string
     */
    public static function getAuditFriendlyFieldJoinCharacter()
    {
        return ' in ';
    }
}
