<?php

namespace Ignite\Claim\Models\Grid;

use Ignite\Claim\Entities\ClaimParticipant;

class ProcessFormatter extends ClaimFormatter
{
    /**
     * Format the actions column.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function actions($model)
    {
        if (! $model) {
            return $this->html('');
        }

        $actions = [];

        if (auth()->user()->can('claim.view')) {
            $actions[] = [
                'click' => '',
                'class' => 'actions',
                'icon' => 'eye-open',
                'label' => 'View',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.claim.quickview', [
                    'claimParticipant' => $model->id,
                    'claim' => $model->claim_id
                ])
            ];
        }

        if (auth()->user()->can('claim.edit')) {
            $actions[] = [
                'click' => '',
                'class' => '',
                'icon' => 'pencil',
                'label' => 'Edit',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.claim.edit', [
                    'claimId' => $model->claim_id,
                    'claimParticipantId' => $model->id
                ])
            ];
        }

        return $this->buttons($actions);
    }

    /**
     * Format the name column.
     *
     * @param  ClaimParticipant $claimParticipant
     * @return \Illuminate\Support\HtmlString
     */
    public function name(ClaimParticipant $claimParticipant)
    {
        if (! $claimParticipant && ! $claimParticipant->participant) {
            return $this->html('');
        }

        return $this->html(
            sprintf(
                '%s %s',
                $claimParticipant->participant->first,
                $claimParticipant->participant->last
            )
        );
    }

    /**
     * Format a checkbox for selecting items in the grid.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        if (! $model) {
            return $this->html('');
        }

        return $this->formatCheckbox($model->id);
    }
}
