<?php

namespace Ignite\Claim\Events\Handlers;

use Ignite\Claim\Repositories\ClaimRepository;
use Ignite\Core\Events\EnrollmentSubmitted;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Nwidart\Modules\Laravel\LaravelFileRepository as ModuleRepository;

class LinkWaitingClaims
{
    /**
     * @var ClaimRepository
     */
    private $claimRepository;

    /**
     * @var ModuleRepository
     */
    private $moduleRepository;

    /**
     * Create the event listener.
     *
     * @param ClaimRepository $claimRepository
     * @param ModuleRepository $moduleRepository
     */
    public function __construct(ClaimRepository $claimRepository, ModuleRepository $moduleRepository)
    {
        $this->claimRepository = $claimRepository;
        $this->moduleRepository = $moduleRepository;
    }

    /**
     * Handle the event.
     *
     * @param EnrollmentSubmitted $event
     *
     * @return void
     * @throws \Nwidart\Modules\Exceptions\ModuleNotFoundException
     */
    public function handle(EnrollmentSubmitted $event)
    {
        if ($this->moduleRepository->isDisabled('Claim')) {
            return;
        }

        /** @var \Ignite\Core\Entities\Participant $participant */
        $participant = $event->participant;

        $response = $this->claimRepository->get([
            'class' => 'claim_participant',
            'action' => 'getList',
            'mode' => 'array',
            'participant_email' => $participant->email,
            'user_id' => 'isnull:'
        ]);

        if (! $response->result) {
            return;
        }

        $claimParticipants = $response->data;

        // Link any Waiting Claims for the Participant
        if (empty($claimParticipants)) {
            return;
        }

        foreach ($claimParticipants as $index => $tmpParticipant) {
            $claimParticipant = &$claimParticipants[$index];
            $claimParticipant['class'] = 'claim_participant';
            $claimParticipant['action'] = 'update';
            $claimParticipant['user_id'] = $participant->getKey();
            $claimParticipant['status'] = 'pending';
        }

        try {
            $response = $this->claimRepository->update($claimParticipants);
            if (! $response->result) {
                logger()->error(
                    "Unable to link waiting claims for participant '{$participant->email}' with ID {$participant->getKey()}."
                );
            }
        } catch (\Exception $e) {
            logger()->error(
                "Error while linking waiting claims for participant '{$participant->email}' with ID {$participant->getKey()}."
            );
        }
    }
}
