<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Entities\Translation;

class Setting extends Model
{
    /** @var string */
    protected $table = 'claim_setting';

    /** @var string */
    protected $primaryKey  = 'id';

    /** @var array */
    protected $guarded = [];

    /**
     * A static cache of settings from the database.
     * @var bool
     */
    protected static $settings = false;

    /**
     * Key-value hash of the database settings.
     * @var bool
     */
    protected static $settingsLookup = false;

    /**
     * Get the settings from the database and cache them into memory.
     *
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public static function getSettings()
    {
        if (! self::$settings) {
            self::$settings = static::all();
            self::$settingsLookup = [];

            foreach (self::$settings as $setting) {
                self::$settingsLookup[$setting->key] = $setting;
            }
        }

        return self::$settings;
    }

    /**
     * Find a setting by key, you can optionally instruct the method to look up
     * the setting in the cached settings collection.
     *
     * @todo Revisit this to set a single standard way to access the setting.
     * @todo Revisit this to return a consistent value.
     * @param  string $key
     * @param  bool   $asLookup
     * @return array|bool|Setting
     */
    public static function byKey($key, $asLookup = true)
    {
        self::getSettings();

        if (strpos($key, '*') !== false) {
            $result = self::$settings->filter(function ($setting) use ($key) {
                return preg_match("~^$key~", $setting->key);
            });
        } else {
            return (! empty(self::$settingsLookup[$key])) ? self::$settingsLookup[$key] : false;
        }


        if ($asLookup) {
            $lookup = [];

            foreach ($result as $status) {
                $lookup[$status->key] = $status->value;
            }

            return $lookup;
        }

        return $result;
    }
}
