<?php

use Ignite\Claim\Entities\OfferPromotion;
use Ignite\Claim\Entities\Rule;

/** @var \Illuminate\Database\Eloquent\Factory $factory */
$factory->define(Rule::class, function (\Faker\Generator $faker) {
    return [
        "offer_promotion_id" => factory(OfferPromotion::class),
        "name" => "Default",
        "order" => 1,
        "value_mode_id" => Rule::VALUE_SOURCE_OFFER,
        "value_type_id" => Rule::VALUE_TYPE_FIXED,
        "value" => 0,
        "max_times" => 0,
        "participants_mode_id" => Rule::PARTICIPANT_MODE_ALL,
        "offers_mode_id" => Rule::OFFER_MODE_ALL,
        "start_date" => now()->startOfMonth(),
        "end_date" => now()->endOfMonth(),
        "status" => 1,
        "created_at" => $faker->date('Y-m-d H:i:s'),
        "updated_at" => $faker->date('Y-m-d H:i:s'),
    ];
});
