<?php

namespace Ignite\Claim\Events;

use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ClaimEvent
{
    use Dispatchable, SerializesModels;

    /**
     * @var string
     */
    public $eventType;

    /**
     * @var array
     */
    public $data;

    /**
     * Create a new event instance.
     *
     * @param string $eventType
     * @param array  $data
     */
    public function __construct($eventType, $data)
    {
        $this->data = $data;
        $this->eventType = $eventType;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return [];
    }
}
