<?php

namespace Ignite\Claim\Scopes;

use Ignite\Claim\Entities\Claim;
use Ignite\Claim\Entities\ClaimParticipant;
use Ignite\Claim\Entities\File;
use Ignite\Claim\Entities\OfferUserPromotionGroup;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class ParticipantScope implements Scope
{
    /**
     * Apply the scope.
     *
     * @param Builder $builder
     * @param Model $model
     *
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        $builder->macro('claimParticipants', function (Builder $builder) {
            return $builder->getModel()->hasMany(ClaimParticipant::class, 'user_id', 'user_id');
        });

        $builder->macro('claims', function (Builder $builder) {
            return $builder->getModel()->hasMany(Claim::class, 'user_id', 'user_id');
        });

        $builder->macro('files', function (Builder $builder) {
            return $builder->getModel()->hasMany(File::class, 'user_id', 'user_id');
        });

        $builder->macro('offerPromotionGroups', function (Builder $builder) {
            return $builder->getModel()->hasMany(OfferUserPromotionGroup::class, 'user_id', 'user_id');
        });
    }
}
