<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimTable extends Migration
{
    protected $tableName = 'claim';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id')->nullable();
            $table->string('claim_type')->nullable()->default(null);
            $table->string('prm_number')->nullable()->default(null);
            $table->string('estimated_revenue')->nullable()->default(null);
            $table->date('deal_registration_date')->nullable()->default(null);
            $table->string('distributor_po_number')->nullable()->default(null);
            $table->double('revenue_sold')->nullable()->default(0);
            $table->date('activity_date')->nullable()->default(null);
            $table->double('sale_value')->nullable()->default(0);
            $table->string('customer_name')->nullable()->default(null);
            $table->string('customer_contact_first')->nullable()->default(null);
            $table->string('customer_contact_last')->nullable()->default(null);
            $table->string('customer_contact_title')->nullable()->default(null);
            $table->string('customer_contact_phone')->nullable()->default(null);
            $table->string('customer_contact_email')->nullable()->default(null);
            $table->string('support_file')->nullable()->default(null);
            $table->text('user_notes')->nullable();
            $table->string('customer_address_1')->nullable()->default(null);
            $table->string('customer_address_2')->nullable()->default(null);
            $table->string('customer_city', 100)->nullable()->default(null);
            $table->string('customer_state', 100)->nullable()->default(null);
            $table->string('customer_postal', 25)->nullable()->default(null);
            $table->string('customer_country', 100)->nullable()->default(null);
            $table->binary('idc')->nullable();
            $table->dateTime('date_submitted')->nullable()->default(null);
            $table->unsignedTinyInteger('archived')->nullable()->default(0);
            $table->softDeletes('deleted_at');
            $table->timestamps();
            $table->foreign('user_id')->references('user_id')->on('core_user')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
