<?php

namespace Ignite\Claim\Services;

use Exception;
use Illuminate\Support\Facades\DB;
use Ignite\Claim\Entities\ClaimParticipant;

class Shredder
{
    public function destroy($ids)
    {
        $participants = ClaimParticipant::query()->onlyTrashed()->whereIn('id', $ids)->get();

        $count = count($ids);

        foreach ($participants as $participant) {
            if (! $this->delete($participant)) {
                --$count;
            }
        }

        return $count;
    }

    protected function delete(ClaimParticipant $participant)
    {
        if (in_array($participant->status, ['approved', 'issued'])) {
            return false;
        }

        DB::beginTransaction();
        try {
            $participant->forceDelete();
            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            $message = sprintf(
                'Unable to delete claim participant with ID: %s. Error: %s',
                $participant->getKey(),
                $e->getMessage()
            );
            throw new \DomainException($message, 0, $e);
        }

        return true;
    }
}
