<?php

namespace Ignite\Claim\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class TransactionScope implements Scope
{
    /**
     * Apply the scope.
     *
     * @param Builder $builder
     * @param Model $model
     *
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        $builder->macro('claimParticipant', function (Builder $builder) {
            return $builder->getModel()->morphTo('claimParticipant', 'related_type', 'related_id');
        });
    }
}
