<?php

namespace Ignite\Claim\Models\Dashboard\Charts;

use Ignite\Core\Facades\Format;
use Illuminate\Support\Facades\DB;
use Ignite\Core\Models\Dashboard\Donut;

class ClaimsStatusDonut extends Donut
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Claims by status',
            'colors' => ['#f39c12', '#00c0ef', '#00a65a', '#dd4b39'],
            'icon'  => 'fa fa-gift',
            'sort'  => 1
        ], $attributes);

        parent::__construct($attributes);
    }


    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'claims-status-donut';
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * Get the correct data value from storage.
     *
     * @return mixed
     */
    public function getData()
    {
        if (! $this->get('data', false)) {
            /**
             * @var \Carbon\Carbon $start
             * @var \Carbon\Carbon $end
             */
            list($start, $end) = $this->getDateRange();

            $this->attributes['data'] = DB::query()
                ->select(
                    DB::raw('status AS label'),
                    DB::raw('COUNT(status) as value')
                )
                ->from('claim_participant')
                ->groupBy('status')
                ->whereIn('status', ['pending', 'issued', 'approved', 'declined'])
                ->whereNull('deleted_at')
                ->whereBetween('created_at', [$start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')])
                ->orderBy(DB::raw('FIELD(status, "pending", "issued", "approved", "declined")'))
                ->get()
                ->map(function ($row) {
                    $row->label = 'Claims ' . ucfirst($row->label);
                    $row->value = (int) Format::amount($row->value, 2);
                    return $row;
                });
        }

        return $this->get('data');
    }
}
