<?php

namespace Ignite\Claim\Models\Dashboard\Charts;

use Illuminate\Database\Query\Builder;

class ClaimsPendingStat extends ClaimMetric
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        parent::__construct(array_merge([
            'label' => 'Claims pending',
            'color' => 'yellow',
            'link'  => url('/admin/claim/process'),
            'sort'  => 1
        ], $attributes));
    }


    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'claims-pending-stat';
    }

    /**
     * Scope the query to include approved claims only.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    protected function scope(Builder $query)
    {
        return $query->where('status', '=', 'declined');
    }
}
