<?php

namespace Ignite\Claim\Models\Dashboard\Charts;

use Illuminate\Database\Query\Builder;

class ClaimsIssuedStat extends ClaimMetric
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        parent::__construct(array_merge([
            'label' => 'Claims issued',
            'color' => 'aqua',
            'link'  => url('/admin/claim/list/issued'),
            'sort'  => 2
        ], $attributes));
    }

    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'claims-issued-stat';
    }

    /**
     * Scope the query to include approved claims only.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    protected function scope(Builder $query)
    {
        return $query->where('status', '=', 'declined');
    }
}
