<?php

namespace Ignite\Claim\Traits;

use Illuminate\Support\Facades\Validator;
use Ignite\Claim\Entities\Dynamic\DynamicModel;

trait ValidatesFields
{
    /**
     * The namespace path to the dynamic model class.
     * @var string
     */
    protected static $IgniteDynamicModel = DynamicModel::class;

    /**
     * A flag to determine if the fields have been updated.
     * @var bool
     */
    protected static $fieldsUpdated = false;

    /**
     * A list of fields to validate.
     * @var array
     */
    protected static $validateFields = false;

    /**
     * Get all fields (or one field if $name is present) to validate.
     *
     * @param  string $name
     * @return array|bool
     */
    public static function getFields($name = '')
    {
        if (! isset(self::$fields)) {
            return empty($name) ? [] : false;
        }

        if ($name != '') {
            return isset(self::$fields[$name]) ? self::$fields[$name] : false;
        }

        return self::$fields;
    }

    /**
     * Set the fields.
     *
     * @param $fields
     */
    public static function setFields($fields)
    {
        self::$fields = $fields;
        self::$fieldsUpdated = true;
    }

    /**
     * Get the validatable fields.
     *
     * @todo Rename this method to indicate intent, does this mean get fields
     * @todo that we should validate or get the fields that have been validated?
     * @return bool
     */
    public static function getValidateFields()
    {
        if (! self::$validateFields) {
            foreach (self::getFields() as $field => $params) {
                if (isset($params['validate'])) {
                    self::$validateFields[$field] = $params;
                }
            }
        }

        return self::$validateFields;
    }

    /**
     * Validate the data.
     *
     * @param  array $data
     * @param  bool  $validateFields
     * @return array
     */
    public static function validate($data, $validateFields = false)
    {
        $errors = [];

        static $rules = false;

        // ------------------------------
        // Make sure the validateFields was initialized
        // ------------------------------
        if (! self::$validateFields) {
            self::getValidateFields();
        }

        // ------------------------------
        // Check if an Empty Array was passed in for validateFields
        // If so, there is nothing to do...
        // ------------------------------
        if (is_array($validateFields) && empty($validateFields)) {
            return $errors;
        }

        // ------------------------------
        // Check if validateFields were passed in
        // ------------------------------
        if ($validateFields === false) {
            $validateFields = array_keys(self::$validateFields);
        }

        $validateFields = array_flip($validateFields);

        // ------------------------------
        // Build Validation Rules
        // ------------------------------
        if (! $rules) {
            static $rules = [];
            foreach ($validateFields as $field => $index) {
                if (isset(self::$validateFields[$field]['validate'])) {
                    $rules[$field] = self::$validateFields[$field]['validate'];
                }
            }
        }

        // ------------------------------
        // Validate Data
        // ------------------------------
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $messageBag = $validator->errors();
            $errors = $messageBag->all();
        }

        return $errors;
    }
}
